async function loadState() {
  return await chrome.storage.local.get({
    enabled: false,
    selectedId: null,
    proxies: [],
    health: {}
  });
}

function el(tag, attrs = {}, children = []) {
  const e = document.createElement(tag);
  Object.entries(attrs).forEach(([k, v]) => {
    if (k === "class") e.className = v;
    else if (k.startsWith("on") && typeof v === "function") e.addEventListener(k.slice(2), v);
    else e.setAttribute(k, v);
  });
  children.forEach(c => e.appendChild(typeof c === "string" ? document.createTextNode(c) : c));
  return e;
}

function render(state) {
  const table = document.getElementById("table");
  const status = document.getElementById("status");
  const sub = document.getElementById("sub");

  table.innerHTML = "";

  sub.textContent = `当前：${state.enabled ? "已启用代理" : "未启用代理"}  •  选中：${state.selectedId || "-"}`;

  table.appendChild(el("div", { class: "row header" }, [
    el("div", {}, ["状态"]),
    el("div", {}, ["名称"]),
    el("div", {}, ["地址"]),
    el("div", {}, ["延迟"]),
    el("div", {}, ["操作"]),
  ]));

  for (const p of state.proxies) {
    const h = state.health?.[p.id];
    const alive = h?.alive === true;
    const dead = h?.alive === false;

    const dot = el("div", { class: `dot ${alive ? "alive" : dead ? "dead" : ""}` });

    const nameCell = el("div", {}, [
      el("div", {}, [p.name || p.id]),
      el("div", { class: "meta" }, [`${p.scheme}  •  ${p.id}`])
    ]);

    const addrCell = el("div", {}, [
      el("div", {}, [`${p.host}:${p.port}`]),
      el("div", { class: "meta" }, [`${p.scheme}://`])
    ]);

    const rttCell = el("div", { class: "badge" }, [
      h ? (alive ? `${h.rtt} ms` : "DOWN") : "未检测"
    ]);

    const connectBtn = el("button", {
      class: "smallbtn primary",
      onclick: async () => {
        // 选择该代理 + 自动开启（你要是不想自动开启，把 enabled:true 去掉）
        await chrome.runtime.sendMessage({ type: "SELECT", selectedId: p.id });
        await chrome.runtime.sendMessage({ type: "TOGGLE", enabled: true });
        const st2 = await loadState();
        render(st2);
      }
    }, ["连接"]);

    const row = el("div", {
      class: `row ${state.selectedId === p.id ? "selected" : ""}`
    }, [
      el("div", {}, [dot]),
      nameCell,
      addrCell,
      rttCell,
      el("div", {}, [connectBtn])
    ]);

    table.appendChild(row);
  }

  status.textContent = `已加载 ${state.proxies.length} 个代理。点击“连接”会切换到该代理并开启。`;
}

async function refreshUI() {
  const st = await loadState();
  render(st);
}

document.addEventListener("DOMContentLoaded", async () => {
  await refreshUI();

  document.getElementById("refresh").addEventListener("click", async () => {
    await chrome.runtime.sendMessage({ type: "REFRESH" });
    await refreshUI();
  });

  document.getElementById("check").addEventListener("click", async () => {
    await chrome.runtime.sendMessage({ type: "CHECK" });
    await refreshUI();
  });

  document.getElementById("back").addEventListener("click", () => {
    // “返回上一页”：优先走 history；如果没有就直接关闭这个标签页
    if (history.length > 1) history.back();
    else window.close();
  });
});
