// config.js (ES Module)

export const CONFIG = {
  API: {
    BASE: "https://86savecloud.com",
    LOGIN: "/browser/login",
    REGISTER: "/browser/register",
    SENDCODE: "/browser/send",
    PRODUCTLIST: "/browser/product_list",
    DOUPGRADE: "/browser/order_down",
    PROXY_LIST: "/browser/proxy_list",
    HEALTH: "/live.txt"
  },

  PROXY: {
    CHECK_TIMEOUT_MS: 6000,
    APPLY_DELAY_MS: 200
  }
};
export const DEFAULT_WHITELIST = [
  "*.ipconfig.io",
"*.huggingface.co",
"*.cursor.com",
"*.grok.com",
"*.btsow.motorcycles",
"*.x.ai",
"*.wikiquote.org",
"*.artstation.com",
"*.poe.com",
"*.x.com",
"*.wikipedia.org",
"*.figma.com",
"*.okx.com",
"*.kwcdn.com",
"*.temu.com",
"*.copilot.microsoft.com",
"*.pximg.net",
"*.pixiv.net",
"*.bstarstatic.com",
"*.bilibili.tv",
"*.ni.com",
"*.tiktok.com",
"*.discord.com",
"*.githubassets.com",
"*.edgeservices.bing.com",
"*.www.bing.com",
"*.openai.com",
"*.quoracdn.net",
"*.quora.com",
"*.bbc.co.uk",
"*.mdpi.com",
"*.telegram.org",
"*.onedrive.live.com",
"*.bnbstatic.com",
"*.binance.cloud",
"*.binance.com",
"*.nyt.com",
"*.steampowered.com",
"*.onekey.so",
"*.whatsapp.net",
"*.whatsapp.com",
"*.bbc.com",
"*.licdn.com",
"*.linkedin.com",
"*.ethermine.org",
"*.amazon-adsystem.com",
"*.media-amazon.com",
"*.ssl-images-amazon.com",
"*.cdnjs.cloudflare.com",
"*.ftchinese.com",
"*.nytimes.com",
"*.gstatic.com",
"*.cancer.gov",
"*.dropboxstatic.com",
"*.dropbox.com",
"*.dwnews.com",
"*.dribbble.com",
"*.behance.net",
"*.newday.me",
"*.pinimg.com",
"*.pinterest.com",
"*.cdninstagram.com",
"*.instagram.com",
"*.zaobao.com.sg",
"*.zaobao.com",
"*.ytimg.com",
"*.ytht.net",
"*.yt.be",
"*.youtubegaming.com",
"*.youtubeeducation.com",
"*.youtubecn.com",
"*.youtube.com",
"*.youtube-nocookie.com",
"*.youtu.be",
"*.youshun12.com",
"*.youporn.com",
"*.yimg.com",
"*.wwe.com",
"*.wsj.net",
"*.wsj.com",
"*.workflow.is",
"*.wordpress.com",
"*.wikiwiki.jp",
"*.wikisource.org",
"*.wikipedia.org",
"*.wikinews.org",
"*.wikimapia.org",
"*.wikilivres.info",
"*.wikileaks.pl",
"*.wikileaks.org",
"*.wikileaks.lu",
"*.w3schools.com",
"*.w3.org",
"*.v2ray.com",
"*.v2ex.com",
"*.unicode.org",
"*.uncyclomedia.org",
"*.uk.to",
"*.uighurbiz.net",
"*.uhrp.org",
"*.ugo.com",
"*.udn.com",
"*.ucam.org",
"*.uberproxy.net",
"*.ubddns.org",
"*.twurl.nl",
"*.twttr.com",
"*.twtrland.com",
"*.twtkr.com",
"*.twt.tl",
"*.twstar.net",
"*.twskype.com",
"*.twiyia.com",
"*.twitzap.com",
"*.twitvid.com",
"*.twitturly.com",
"*.twitturk.com",
"*.twitthat.com",
"*.twittertim.es",
"*.twitterrific.com",
"*.twittermail.com",
"*.twitterkr.com",
"*.twittergadget.com",
"*.twitterfeed.com",
"*.twittercounter.com",
"*.twitter4j.org",
"*.twitter.jp",
"*.twitter.com",
"*.twittbot.net",
"*.twitstat.com",
"*.twitpic.com",
"*.twitoaster.com",
"*.twitmania.com",
"*.twitlonger.com",
"*.twitiq.com",
"*.twitgoo.com",
"*.twitchcdn.net",
"*.twitch.tv",
"*.twitcause.com",
"*.twitbrowser.net",
"*.twit2d.com",
"*.twistory.net",
"*.twisternow.com",
"*.twisterio.com",
"*.twister.net.co",
"*.twishort.com",
"*.twipple.jp",
"*.twip.me",
"*.twindexx.com",
"*.twimg.com",
"*.twimbow.com",
"*.twilog.org",
"*.twilio.com",
"*.twilightsex.com",
"*.twiggit.org",
"*.twiffo.com",
"*.twifan.com",
"*.twiends.com",
"*.twicsy.com",
"*.twicountry.org",
"*.twibs.com",
"*.twibbon.com",
"*.twibble.de",
"*.twibase.com",
"*.twgreatdaily.com",
"*.twftp.org",
"*.twerkingbutt.com",
"*.twelve.today",
"*.tweez.net",
"*.tweetymail.com",
"*.tweetwally.com",
"*.tweettunnel.com",
"*.tweetree.com",
"*.tweetrans.com",
"*.tweetphoto.com",
"*.tweetmylast.fm",
"*.tweetedtimes.com",
"*.tweetdeck.com",
"*.tweetcs.com",
"*.tweetboner.biz",
"*.tweetboard.com",
"*.tweetbackup.com",
"*.tweepml.org",
"*.tweepmag.com",
"*.tweeplike.me",
"*.tweepguide.com",
"*.twblogger.com",
"*.twbbs.org",
"*.twavi.com",
"*.twaud.io",
"*.twapperkeeper.com",
"*.twaitter.com",
"*.tw01.org",
"*.tw-npo.org",
"*.tw-blog.com",
"*.tvunetworks.com",
"*.tvplayvideos.com",
"*.tvider.com",
"*.tvboxnow.com",
"*.tvb.com",
"*.tvants.com",
"*.tv.com",
"*.tuzaijidi.com",
"*.tutanota.com",
"*.tushycash.com",
"*.turntable.fm",
"*.turbotwitter.com",
"*.turbohide.com",
"*.turbobit.net",
"*.turansam.org",
"*.tuo8.red",
"*.tuo8.pw",
"*.tuo8.org",
"*.tuo8.ninja",
"*.tuo8.in",
"*.tuo8.club",
"*.tuo8.blue",
"*.tunnelr.com",
"*.tunnelbear.com",
"*.tunein.com",
"*.tumview.com",
"*.tumutanzi.com",
"*.tumblr.com",
"*.tuitwit.com",
"*.tuitui.info",
"*.tube8.com",
"*.tube.com",
"*.tacem.org",
"*.t.me",
"*.t.co",
"*.skype.com",
"*.rocket-inc.net",
"*.robustnessiskey.com",
"*.roboforex.com",
"*.rg3.github.io",
"*.revver.com",
"*.revocationcheck.com",
"*.revleft.com",
"*.reutersmedia.net",
"*.reuters.com",
"*.retweetrank.com",
"*.retweetist.com",
"*.retweeteffect.com",
"*.resilio.com",
"*.rerouted.org",
"*.renyurenquan.org",
"*.renminbao.com",
"*.religioustolerance.org",
"*.releaseinternational.org",
"*.relaxbbs.com",
"*.reflectivecode.com",
"*.referer.us",
"*.redtube.com",
"*.redhotlabs.com",
"*.redditstatic.com",
"*.redditmedia.com",
"*.redditlist.com",
"*.reddit.com",
"*.redd.it",
"*.recaptcha.net",
"*.rd.com",
"*.raxcdn.com",
"*.rawgithub.com",
"*.rawgit.com",
"*.raw.githubusercontent.com",
"*.rael.org",
"*.radiovncr.com",
"*.radiovaticana.org",
"*.radiotime.com",
"*.radiohilight.net",
"*.radioaustralia.net.au",
"*.radiko.jp",
"*.radicalparty.org",
"*.pythonhackers.com",
"*.python.com",
"*.putty.org",
"*.igoogle.com",
"*.huobipro.com",
"*.huobi.pro",
"*.huobi.com",
"*.hulu.com",
"*.gov.tw",
"*.gotw.ca",
"*.gotrusted.com",
"*.gotgeeks.com",
"*.gotdns.ch",
"*.got-game.org",
"*.gospelherald.com",
"*.goregrish.com",
"*.goproxing.net",
"*.gopetition.com",
"*.googlezip.net",
"*.googleweblight.com",
"*.googlevideo.com",
"*.googleusercontent.com",
"*.googlesyndication.com",
"*.googlesource.com",
"*.googlesile.com",
"*.googlescholar.com",
"*.googleplus.com",
"*.googleplay.com",
"*.googlepagecreator.com",
"*.googlemashups.com",
"*.googlemail.com",
"*.googlelabs.com",
"*.googleinsidesearch.com",
"*.googleideas.com",
"*.googlehosted.com",
"*.googlegroups.com",
"*.googleearth.com",
"*.googledrive.com",
"*.googledomains.com",
"*.googlecommerce.com",
"*.googlecode.com",
"*.googlechinawebmaster.com",
"*.googlebot.com",
"*.googleblog.com",
"*.googleartproject.com",
"*.googlearth.com",
"*.googleapps.com",
"*.googleapis.cn",
"*.googleadsserving.cn",
"*.googleadservices.com",
"*.google.ws",
"*.google.vu",
"*.google.tt",
"*.google.to",
"*.google.tm",
"*.google.tk",
"*.google.sn",
"*.google.sm",
"*.google.sk",
"*.google.sh",
"*.google.sc",
"*.google.rw",
"*.google.ru",
"*.google.ro",
"*.google.nu",
"*.google.no",
"*.google.nl",
"*.google.ms",
"*.google.mn",
"*.google.lv",
"*.google.kz",
"*.google.jo",
"*.google.it",
"*.google.is",
"*.google.ie",
"*.google.gr",
"*.google.gl",
"*.google.gg",
"*.google.fr",
"*.google.fm",
"*.google.fi",
"*.google.es",
"*.google.dk",
"*.google.dj",
"*.google.de",
"*.google.com.hk",
"*.google.com",
"*.google.co.ma",
"*.google.co.kr",
"*.google.co.jp",
"*.google.co.id",
"*.google.ci",
"*.google.cd",
"*.google.ca",
"*.google.bg",
"*.google.be",
"*.google.ba",
"*.google.az",
"*.google.at",
"*.google.as",
"*.google.am",
"*.google.ae",
"*.google-analytics.com",
"*.goofind.com",
"*.goodtv.tv",
"*.goodreads.com",
"*.goodreaders.com",
"*.gooddns.info",
"*.gooday.xyz",
"*.goo.ne.jp",
"*.goo.gl",
"*.gongwt.com",
"*.gongminliliang.com",
"*.gongmeng.info",
"*.gongm.in",
"*.goldwave.com",
"*.goldstep.net",
"*.goldjizz.com",
"*.goldenfrog.com",
"*.goldeneyevault.com",
"*.goldbetsports.com",
"*.goldbet.com",
"*.golang.org",
"*.gokbayrak.com",
"*.gogotunnel.com",
"*.godsimmediatecontact.com",
"*.godsdirectcontact.org",
"*.godoc.org",
"*.godns.work",
"*.godfootsteps.org",
"*.goagentplus.com",
"*.goagent.biz",
"*.go141.com",
"*.go-pki.com",
"*.gmodules.com",
"*.gmll.org",
"*.gmiddle.net",
"*.gmiddle.com",
"*.gmhz.org",
"*.gmail.com",
"*.glype.com",
"*.gluckman.com",
"*.glorystar.me",
"*.gloryhole.com",
"*.glock.com",
"*.globalvoicesonline.org",
"*.globalvoices.org",
"*.globaltm.org",
"*.globalrescue.net",
"*.globalmuseumoncommunism.org",
"*.globalmediaoutreach.com",
"*.globaljihad.net",
"*.glass8.eu",
"*.gjczz.com",
"*.gizlen.net",
"*.github.com",
"*.gitbooks.io",
"*.git.io",
"*.girlbanker.com",
"*.gigporno.ru",
"*.giganews.com",
"*.gigacircle.com",
"*.giga-web.jp",
"*.gifree.com",
"*.giantessnight.com",
"*.ghut.org",
"*.ghostpath.com",
"*.ggssl.com",
"*.ggpht.com",
"*.gfw.org.ua",
"*.gfsale.com",
"*.gfbv.de",
"*.getuploader.com",
"*.gettyimages.com",
"*.gettrials.com",
"*.getsync.com",
"*.getsocialscope.com",
"*.getoutline.org",
"*.getmdl.io",
"*.getlantern.org",
"*.getjetso.com",
"*.getiton.com",
"*.geti2p.net",
"*.getgom.com",
"*.getfreedur.com",
"*.getfoxyproxy.org",
"*.getcloak.com",
"*.getchu.com",
"*.getastrill.com",
"*.get.how",
"*.gerhards.net",
"*.gerefoundation.org",
"*.geocities.jp",
"*.geocities.com",
"*.geocities.co.jp",
"*.g.co",
"*.flickr.com",
"*.fbworkmail.com",
"*.fbsbx.com",
"*.fbcdn.net",
"*.fb.me",
"*.fb.com",
"*.facebookmail.com",
"*.facebook.se",
"*.facebook.nl",
"*.facebook.net",
"*.facebook.in",
"*.facebook.hu",
"*.facebook.com",
"*.facebook.br",
"*.economist.com",
"*.dynu.net",
"*.dynu.com",
"*.dynssl.com",
"*.dyndns.pro",
"*.dyndns.org",
"*.dyndns-pics.com",
"*.dyndns-ip.com",
"*.dynawebinc.com",
"*.dynamicdns.biz",
"*.dynamic-dns.net",
"*.docker.io",
"*.docker.com",
"*.de-sci.org",
"*.ddns.us",
"*.ddns.net",
"*.ddns.name",
"*.ddns.ms",
"*.ddns.mobi",
"*.ddns.info",
"*.co.uk",
"*.chromium.org",
"*.chromestatus.com",
"*.chromercise.com",
"*.chromeexperiments.com",
"*.chromecast.com",
"*.chrome.com",
"*.box.net",
"*.box.com",
"*.blogspot.com",
"*.blogs.com",
"*.blogger.com",
"*.bit.ly",
"*.bbc.in",
"*.archives.gov",
"*.archive.today",
"*.archive.org",
"*.archive.li",
"*.archive.is",
"*.archive.fo",
"*.aptoide.com",
"*.appsto.re",
"*.appspot.com",
"*.appsocks.net",
"*.appshopper.com",
"*.appledaily.com",
"*.apple.com",
"*.appelsiini.net",
"*.appdownloader.net",
"*.apkpure.com",
"*.apkplz.com",
"*.apkmonk.com",
"*.apkmirror.com",
"*.apkdler.com",
"*.apk-dl.com",
"*.apigee.com",
"*.apiary.io",
"*.api.ai",
"*.apetube.com",
"*.apartments.com",
"*.apartmentratings.com",
"*.ap.org",
"*.aomiwang.com",
"*.aolnews.com",
"*.aolcdn.com",
"*.aol.com",
"*.aol.ca",
"*.aojiao.org",
"*.aofriend.com.au",
"*.aofriend.com",
"*.aobo.com.au",
"*.anysex.com",
"*.anyporn.com",
"*.antiwave.net",
"*.antichristendom.com",
"*.anti1984.com",
"*.anthonycalzadilla.com",
"*.antd.org",
"*.answering-islam.org",
"*.anpopo.com",
"*.anonymouse.org",
"*.anonymizer.com",
"*.anonymitynetwork.com",
"*.anonymise.us",
"*.anontext.com",
"*.anobii.com",
"*.annatam.com",
"*.aniscartujo.com",
"*.animeshippuuden.com",
"*.animecrazy.net",
"*.angularjs.org",
"*.angola.org",
"*.angelfire.com",
"*.angela-merkel.de",
"*.andygod.com",
"*.androidtv.com",
"*.androidplus.co",
"*.androidify.com",
"*.android.com",
"*.android-x86.org",
"*.andfaraway.net",
"*.ancsconf.org",
"*.anchorfree.com",
"*.amtb-taipei.org",
"*.ampproject.org",
"*.amoiist.com",
"*.amnyemachen.org",
"*.amnestyusa.org",
"*.amnesty.org",
"*.amitabhafoundation.us",
"*.amigobbs.net",
"*.amiblockedornot.com",
"*.americorps.gov",
"*.americanunfinished.com",
"*.americangreencard.com",
"*.american.edu",
"*.america.gov",
"*.ameblo.jp",
"*.amazonaws.com",
"*.amazon.com",
"*.amazon.co.jp",
"*.alwaysdata.net",
"*.alwaysdata.com",
"*.alvinalexander.com",
"*.altrec.com",
"*.alternativeto.net",
"*.alternate-tools.com",
"*.alphaporno.com",
"*.almostmy.com",
"*.almasdarnews.com",
"*.allowed.org",
"*.akiba-web.com",
"*.akiba-online.com",
"*.akamaized.net",
"*.akamaistream.net",
"*.akamaihd.net",
"*.akamai.net"
  
];
// 🔧 统一生成完整 URL（防止手写拼错）
export function apiUrl(path) {
  return CONFIG.API.BASE + path;
}
