import { CONFIG, apiUrl } from "../config.js";
import { buildEmail, normalizePayloadData, vipText, postForm } from "../lib/auth_util.js";

const LOGIN_URL = apiUrl(CONFIG.API.LOGIN);

document.addEventListener("DOMContentLoaded", () => {
  const status = document.getElementById("status");
  const btnLogin = document.getElementById("login");

  document.getElementById("register").addEventListener("click", () => {
    location.href = chrome.runtime.getURL("pages/user/register.html");
  });
  btnLogin.onclick = async () => {
    const usernameInput = document.getElementById("username").value.trim();
    const ext = document.getElementById("login_mail_ext")?.value || "";
    const emailInput = buildEmail(usernameInput, ext);
    const password = document.getElementById("password").value;

    if (!usernameInput || !password) {
      status.textContent = "请输入用户名和密码";
      return;
    }
    if (!emailInput) {
      status.textContent = "邮箱格式不正确";
      return;
    }

    status.textContent = "登录中...";

    try {
      const r = await postForm(LOGIN_URL, { username: usernameInput, email : emailInput, password, from: 'browser', remember_me: false });
      const payload = r.json;

      if (!payload) {
        status.textContent = "接口返回不是 JSON：\n" + r.raw;
        return;
      }

      // 你当前规则：ret === "1" 成功
      if (payload.ret !== "1") {
        status.textContent = payload.message || payload.msg || "登录失败";
        return;
      }

      const data = normalizePayloadData(payload);
      //console.log(data);
      if (!data) {
        status.textContent = "登录成功但 data 解码失败";
        return;
      }

      const username = data.username || usernameInput;
      const email = data.email;
      const token = data.token;
      const expire = data.expire;
      const vip = data.vip ?? "0";
      const speed = data.speeed ?? "N/A";
      const quota = data.quota ?? "N/A";

      if (!token) {
        status.textContent = "登录成功但未返回 token";
        return;
      }

      await chrome.storage.local.set({ loggedIn: true, email, username, token, expire, vip, speed, quota});
      chrome.runtime.sendMessage({ type: "AUTH_UPDATED" });
      chrome.runtime.sendMessage({ type: "REFRESH" });

      status.textContent = `登录成功：${username}（${vipText(vip)}）`;
      setTimeout(() => {
        location.href = chrome.runtime.getURL("pages/welcome.html");
      }, 100);
      
      // window.close();
    } catch (e) {
      status.textContent = "请求失败：" + (e?.message || String(e));
    }
  };
});
