function pad2(n) {
  n = Number(n);
  return n < 10 ? "0" + n : "" + n;
}
function quotaText(m) {
  if (m === undefined || m === null || m === "") return "-";
  const n = Number(m);
  if (!Number.isFinite(n)) return String(m);
  return `${n.toFixed(2)}`;
}

function formatExpire(expire) {
  // expire 可能是：
  // 1) Unix 秒 (1798732800)
  // 2) 毫秒
  // 3) 字符串数字
  if (!expire) return "未设置";

  let t = Number(expire);
  if (!Number.isFinite(t) || t <= 0) return "无效";

  // 如果像毫秒（>= 10^12），转成秒
  if (t > 1e12) t = Math.floor(t / 1000);

  // 用本地时间显示
  const d = new Date(t * 1000);
  const y = d.getFullYear();
  const m = pad2(d.getMonth() + 1);
  const day = pad2(d.getDate());
  const hh = pad2(d.getHours());
  const mm = pad2(d.getMinutes());

  return `${y}-${m}-${day} ${hh}:${mm}`;
}

function vipText(vip) {
  if (vip === undefined || vip === null || vip === 0) return "免费用户";
  const n = Number(vip);
  if (Number.isFinite(n)) return `VIP${n}`;
  return String(vip);
}

async function loadUser() {
  const elName = document.getElementById("u_name");
  const elVip = document.getElementById("u_vip");
  const elExpire = document.getElementById("u_expire");
  const elQuota = document.getElementById("u_quota");
  const clientList = document.getElementById("client_list");

  const st = await chrome.storage.local.get([
    "loggedIn",
    "email",
    "username",
    "vip",
    "expire",
    "speed",
    "quota"
  ]);

  // 没登录就跳回登录页（按你项目实际路径改）
  if (!st.loggedIn) {
    // 如果你是扩展页面登录：例如 pages/auth/login.html
    location.href = chrome.runtime.getURL("pages/user/login.html");
    return;
  }

  elName.textContent = st.username || "-";
  elVip.textContent = vipText(st.vip);
  elExpire.textContent = formatExpire(st.expire);
  elQuota.textContent = quotaText(st.quota);
  if (clientList) {
    const vipLevel = Number(st.vip || 0);
    clientList.style.display = vipLevel > 1 ? "block" : "none";
  }
}

function bindDownloads() {
  document.querySelectorAll("[data-url]").forEach(btn => {
    btn.addEventListener("click", () => {
      const url = btn.getAttribute("data-url");
      if (!url) return;
      chrome.tabs.create({ url });
    });
  });
}

async function doLogout() {
  await chrome.storage.local.remove(["loggedIn", "email","username", "token", "vip", "expire"]);
  chrome.runtime.sendMessage({ type: "AUTH_UPDATED" });
  // 退出后跳回登录页（按你项目实际路径改）
  location.href = chrome.runtime.getURL("pages/user/login.html");
}

function bindFooter() {
  //const back = document.getElementById("btn_health");
  const logout = document.getElementById("btn_logout");

//   back.addEventListener("click", () => {
//     // 如果你的主界面是 popup，不一定能跳回；这里给一个常见入口
//     // 你可以改成 options.html / main.html
//     location.href = chrome.runtime.getURL("pages/user/login.html");
//   });

  logout.addEventListener("click", doLogout);
}

function bindHeroActions() {
  const btnHealth = document.getElementById("btn_health");
  const btnPay = document.getElementById("btn_pay");

  if (btnHealth) {
    btnHealth.addEventListener("click", () => {
      location.href = chrome.runtime.getURL("pages/health.html");
    });
  }

  if (btnPay) {
    btnPay.addEventListener("click", () => {
      location.href = chrome.runtime.getURL("pages/upgrade.html");
    });
  }
}


document.addEventListener("DOMContentLoaded", async () => {
  await loadUser();
  bindDownloads();
  bindHeroActions();
  bindFooter();
  
});
